// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 14, Aufgabe 7
// "Tuerme von Hanoi"

// Three stacks are used to visualize the poles
class Stack {
	int[] val = new int[32];
	int top = 0;
	
	void push(int x) { val[top++] = x; }
	int  pop() { return val[--top]; }
	void print() { for (int i = 0; i < top; i++) print(val[i] + " "); }
}

public class A7 {
	static final int n = 5;             // the number of disks to be moved
	static Stack[] pole = new Stack[3]; // the 3 poles
	
	// print the poles
	static void print() {
		pole[0].print(); println();
		pole[1].print(); println();
		pole[2].print(); println();
		Out.println("-----");
	}
	
	// Move n disks from "from" to "to"
	static void move(int n, int from, int to) {
		if (n > 0) {
			int free = 3 - (from + to);
			move(n-1, from, free);
			pole[to].push(pole[from].pop());  // move last disk from "from" to "to"
			print();
			move(n-1, free, to);
		}
	}
	
	public static void main(String args[]) {
		for (int i = 0; i < 3; i++) pole[i] = new Stack();
		for (int i = n; i > 0; i--) pole[0].push(i);
		move(n, 0, 1);
	}
}
